/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.gunner;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.gunner.IDifficultyProperty;
import dev.toma.gunsrpg.resource.gunner.MultiChoicePropertySelector;
import dev.toma.gunsrpg.resource.gunner.SimpleDifficultyProperty;

public final class DifficultyPropertyResolver {
    public static <T> IDifficultyProperty<T> resolve(JsonElement element, IResolver<T> resolver) throws JsonSyntaxException {
        boolean simple = element.isJsonPrimitive();
        if (simple) {
            T t = resolver.resolve(element);
            return new SimpleDifficultyProperty<T>(t);
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            Object[] props = new Object[array.size()];
            int index = 0;
            for (JsonElement jsonElement : array) {
                props[index++] = resolver.resolve(jsonElement);
            }
            return new MultiChoicePropertySelector<Object>(props);
        }
        throw new JsonSyntaxException("Property must be either primitive or primite array");
    }

    private DifficultyPropertyResolver() {
    }

    @FunctionalInterface
    public static interface IResolver<T> {
        public T resolve(JsonElement var1) throws JsonSyntaxException;
    }
}

